
<?php $__env->startSection('title'); ?>
  <?php echo e(__("message.My Addresses")); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-data'); ?>
<meta property="og:type" content="website"/>
<meta property="og:url" content="<?php echo e(route('my-addresses')); ?>"/>
<meta property="og:title" content="<?php echo e(__('message.site_name')); ?>"/>
<meta property="og:image" content="<?php echo e(asset('public/img/').'/'.$setting->logo); ?>"/>
<meta property="og:image:width" content="250px"/>
<meta property="og:image:height" content="250px"/>
<meta property="og:site_name" content="<?php echo e(__('message.site_name')); ?>"/>
<meta property="og:description" content="<?php echo e(__('message.meta_description')); ?>"/>
<meta property="og:keyword" content="<?php echo e(__('message.meta_keyword')); ?>"/>
<link rel="shortcut icon" href="<?php echo e(asset('public/img/').'/'.$setting->favicon); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="doctors-dashboard bg-color-3">
   <div class="left-panel">
      <div class="profile-box patient-profile">
         <div class="upper-box">
            <?php 
                              if(Auth::user()->profile_pic!=""){
                                  $path=url('/')."/storage/app/public/profile"."/".Auth::user()->profile_pic;
                              }
                              else{
                                  $path=asset('public/img/default_user.png');
                              }
                              ?>
           
            <figure class="profile-image"><img src="<?php echo e($path); ?>" alt=""></figure>
            <div class="title-box centred">
               <div class="inner">
                  <h3><?php echo e(Auth::user()->name); ?></h3>
                  <p><i class="fas fa-envelope"></i><?php echo e(Auth::user()->email); ?></p>
               </div>
            </div>
         </div>
         <div class="profile-info">
            <ul class="list clearfix">
               <li><a href="<?php echo e(route('dashboard')); ?>"><i class="fas fa-columns"></i><?php echo e(__("message.Dashboard")); ?></a></li>
               
               <li><a href="<?php echo e(route('my-family-member')); ?>"><i class="fas fa-clock"></i><?php echo e(__("message.My Family Members")); ?></a></li>
               <li><a href="<?php echo e(route('my-addresses')); ?>" class="current"><i class="fas fa-comments"></i><?php echo e(__("message.My Addresses")); ?></li>
               <li><a href="<?php echo e(route('user-profile')); ?>"><i class="fas fa-user"></i><?php echo e(__("message.My Profile")); ?></a></li>
               <li><a href="<?php echo e(route('user-change-password')); ?>"><i class="fas fa-unlock-alt"></i><?php echo e(__("message.Change Password")); ?></a></li>
               <li><a href="<?php echo e(route('user-logout')); ?>"><i class="fas fa-sign-out-alt"></i><?php echo e(__("message.Logout")); ?></a></li>
            </ul>
         </div>
      </div>
   </div>
   <div class="right-panel">
                <div class="content-container">
                    <div class="outer-container">
                        <div class="favourite-doctors">
                            <div class="title-box row">
                                <h3 class="col-md-6"><?php echo e(__("message.My Addresses")); ?></h3>
                                <div class="btn-box col-md-6 tdr"><a href="javascript::void(0)" class="theme-btn-one" data-toggle="modal" data-target="#addaddress"><i class="icon-image" ></i><?php echo e(__("message.Add Address")); ?></a></div>
                            </div>
                            <div class="doctors-list">
                                <div class="row clearfix">
                                 <?php if(count($myaddresses)>0): ?>
                                    <?php $__currentLoopData = $myaddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <div class="col-xl-6 col-lg-6 col-md-12 doctors-block">
                                           <div class="team-block-three">
                                               <div class="inner-box">
                                                   <div class="lower-content">
                                                       <ul class="name-box clearfix">
                                                           <li class="name"><h3><a href="doctors-details.html"><?php echo e($ma->name); ?></a></h3></li>
                                                           <?php if($ma->is_default=='1'): ?>
                                                           <li><span style="font-size: small;"><?php echo e(__("message.Default")); ?> </span></li>
                                                           <?php endif; ?>
                                                       </ul>
                                                       <span class="designation"><i class="fas fa-map-marker-alt"></i> <?php echo e($ma->house_no); ?> , <?php echo e($ma->address); ?> , <?php echo e($ma->city); ?> , <?php echo e($ma->state); ?> , <?php echo e($ma->pincode); ?></span>
                                                       

                                                       <div class="btn-box row">
                     <button type="button" style="position: relative;display: inline-block;float: left;
    font-size: 15px;Line-height: 26px;font-weight: 600;border: 2px solid #ebeef1;border-radius: 30px;   
    padding: 7px 27px;text-align: center;background: #453f85;color: white;" data-toggle="modal" data-target="#editaddress" onclick="editaddress('<?php echo e($ma->id); ?>')"><?php echo e(__("message.Edit")); ?> <i class="fa fa-edit"></i></button>
                      <button type="submit" style="position: relative;display: inline-block;float: left;
    font-size: 15px;Line-height: 26px;font-weight: 600;border: 2px solid #ebeef1;border-radius: 30px;   
    padding: 7px 27px;text-align: center;background: #f01634;color: white;" onclick="deleteaddress('<?php echo e($ma->id); ?>')">Delete <i class="fa fa-trash"></i></button>
                  </div>
                                                   </div>
                                               </div>
                                           </div>
                                       </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <?php endif; ?> 
                                </div>
                            </div>
                         
                        </div>
                    </div>
                </div>
            </div>
</section>
<div class="modal" id="addaddress">
   <div class="modal-dialog modal-lg">
      <div class="modal-content">
         <!-- Modal Header -->
         <div class="modal-header">
            <h4 class="modal-title"><?php echo e(__("message.Add New Address")); ?></h4>
            <button type="button" class="close" data-dismiss="modal">&times;</button>
         </div>
         <!-- Modal body -->
         <div class="modal-body">
            <form action="<?php echo e(route('post-user-address')); ?>" method="post" id="user_address" class="registration-form">
               <?php echo e(csrf_field()); ?>

               <div class="row clearfix">
                  <div class="col-lg-12 col-md-6 col-sm-12 form-group"  id="addressorder">
                     <label><?php echo e(__("message.Address")); ?><span class="reqfield">*</span></label>
                     <input  type="text" id="us2-address" name="address" placeholder='<?php echo e(__("message.Search Location")); ?>' required data-parsley-required="true" required=""/>
                  </div>
                  <div class="map col-lg-12 col-md-6 col-sm-12 form-group" id="maporder">
                     <div class="form-group">
                        <div class="col-md-12 p-0">
                           <div id="us2"></div>
                        </div>
                     </div>
                  </div>
                  <input type="hidden" name="lat" id="us2-lat" value="<?php echo e(env('MAP_LAT')); ?>" />
                  <input type="hidden" name="long" id="us2-lon" value="<?php echo e(env('MAP_LONG')); ?>" />
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.Name")); ?></label>
                     <input type="text" name="name"  placeholder="<?php echo e(__('message.Enter Name')); ?>" required="">
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.House no")); ?></label>
                     <input type="text" name="house_no" placeholder="<?php echo e(__('message.Enter House No')); ?>" required="">
                  </div>
                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                     <label><?php echo e(__("message.City")); ?></label>
                      <select  name="city" required="" >
                              <option value=""><?php echo e(__("message.Select City")); ?></option>
                              <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.State")); ?></label>
                     <input type="text" name="state" placeholder="<?php echo e(__('message.Enter State')); ?>" required="">
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.Pincode")); ?></label>
                     <input type="text" name="pincode"  placeholder="<?php echo e(__('message.Enter Pincode')); ?>"  required="">
                  </div>
                  <div class="col-lg-6 col-md-12 col-sm-12 form-group" style="margin-top: 35px;">
                     <div class="custom-check-box">
                        <div class="custom-controls-stacked">
                           <label class="custom-control material-checkbox">
                           <input type="radio" name="is_default" id="is_default" value="1" class="material-control-input">
                           <span class="material-control-indicator"></span>
                           <span class="description"><?php echo e(__("message.Make Default Address")); ?></span>
                           </label>
                        </div>
                     </div>
                  </div>
               </div>
         </div>
         <!-- Modal footer -->
         <div class="modal-footer">
         <button type="submit" id="address_submit_button" class="btn btn-success"><?php echo e(__("message.Add Address")); ?></button>
         <button type="button" class="btn btn-danger" data-dismiss="modal" ><?php echo e(__("message.Close")); ?></button>
         </div>
         </form>
      </div>
   </div>
</div>
<div class="modal" id="editaddress">
   <div class="modal-dialog modal-md">
      <div class="modal-content">
         <!-- Modal Header -->
         <div class="modal-header">
            <h4 class="modal-title"><?php echo e(__("message.Edit Address")); ?></h4>
            <button type="button" class="close" data-dismiss="modal">&times;</button>
         </div>
         <!-- Modal body -->
         <div class="modal-body">
            <form action="<?php echo e(route('post-user-address')); ?>" method="post" id="user_address" class="registration-form">
               <?php echo e(csrf_field()); ?>

               <input type="hidden" name="id" id="edit_id">
               <div class="row clearfix">
                  <div class="col-lg-12 col-md-6 col-sm-12 form-group"  id="addressorder">
                     <label><?php echo e(__("message.Address")); ?><span class="reqfield">*</span></label>
                     <input  type="text" id="us2-address_edit" name="address" placeholder='<?php echo e(__("message.Search Location")); ?>' required data-parsley-required="true" required=""/>
                  </div>
                  <div class="map col-lg-12 col-md-6 col-sm-12 form-group" id="maporder">
                     <div class="form-group">
                        <div class="col-md-12 p-0">
                           <div id="us2_edit"></div>
                        </div>
                     </div>
                  </div>
                  <input type="hidden" name="lat" id="us2-lat-edit" value="<?php echo e(env('MAP_LAT')); ?>" />
                  <input type="hidden" name="long" id="us2-lon-edit" value="<?php echo e(env('MAP_LONG')); ?>" />
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.Name")); ?></label>
                     <input type="text" name="name" id="name" placeholder="<?php echo e(__('message.Enter Name')); ?>" required="">
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.House no")); ?></label>
                     <input type="text" name="house_no" id="house_no" placeholder="<?php echo e(__('message.Enter House No')); ?>" required="">
                  </div>
                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                     <label><?php echo e(__("message.City")); ?></label>
                      <select id="city" name="city" required="" >
                              <option value=""><?php echo e(__("message.Select City")); ?></option>
                              <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.State")); ?></label>
                     <input type="text" name="state" id="state" placeholder="<?php echo e(__('message.Enter State')); ?>" required="">
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                     <label><?php echo e(__("message.Pincode")); ?></label>
                     <input type="text" name="pincode" id="pincode" placeholder="<?php echo e(__('message.Enter Pincode')); ?>"  required="">
                  </div>
                  <div class="col-lg-6 col-md-12 col-sm-12 form-group" style="margin-top: 35px;">
                     <div class="custom-check-box">
                        <div class="custom-controls-stacked">
                           <label class="custom-control material-checkbox">
                           <input type="radio" name="is_default" id="is_default_edit" value="1" class="material-control-input">
                           <span class="material-control-indicator"></span>
                           <span class="description"><?php echo e(__("message.Make Default Address")); ?></span>
                           </label>
                        </div>
                     </div>
                  </div>
               </div>
         </div>
         <!-- Modal footer -->
         <div class="modal-footer">
         <button type="submit" id="address_submit_button" class="btn btn-success"><?php echo e(__("message.Update Address")); ?></button>
         <button type="button" class="btn btn-danger" data-dismiss="modal" ><?php echo e(__("message.Close")); ?></button>
         </div>
         </form>
      </div>
   </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/freakd1c/public_html/demo/laboratory/resources/views/front/myaddresses.blade.php ENDPATH**/ ?>