
<?php $__env->startSection('title'); ?>
<?php echo e(__("message.Orders List")); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
   <h3 class="page-title"><?php echo e(__("message.Orders List")); ?></h3>
   <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
         <li class="breadcrumb-item"><a href="<?php echo e(route('manager-dashboard')); ?>"><?php echo e(__("message.Home")); ?></a></li>
         <li class="breadcrumb-item active"><?php echo e(__("message.Orders List")); ?></li>
      </ol>
   </nav>
</div>
<div class="row">
   <div class="col-lg-12 grid-margin stretch-card">
      <div class="card">
         <div class="card-body">
            <?php if(Session::has('message')): ?>
            <div class="col-sm-12">
               <div class="alert  <?php echo e(Session::get('alert-class', 'alert-info')); ?> alert-dismissible fade show" role="alert"><?php echo e(Session::get('message')); ?>

                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                  </button>
               </div>
            </div>
            <?php endif; ?>
            <div class="table-responsive">
               <table id="OrdersTable" class="table table-bordered text-nowrap dataTable no-footer">
                  <thead>
                     <tr>
                        <th><?php echo e(__("message.Id")); ?></th>
                        <th><?php echo e(__("message.Customer Name")); ?></th>
                        <th><?php echo e(__("message.Address")); ?></th>
                        <th><?php echo e(__("message.Sample Collection DateTime")); ?></th>
                        <th><?php echo e(__("message.Payment Method")); ?></th>
                        <th><?php echo e(__("message.Paid Amount")); ?></th>
                        <th><?php echo e(__("message.More")); ?></th>
                        <th><?php echo e(__("message.Print")); ?></th>
                        <th><?php echo e(__("message.Status")); ?></th>
                        <th><?php echo e(__("message.Action")); ?></th>
                     </tr>
                  </thead>
                  <tbody>                        
                  </tbody>
                  <tfoot>
                     <th><?php echo e(__("message.Id")); ?></th>
                     <th><?php echo e(__("message.Customer Name")); ?>e</th>
                     <th><?php echo e(__("message.Address")); ?></th>
                     <th><?php echo e(__("message.Sample Collection DateTime")); ?></th>
                     <th><?php echo e(__("message.Payment Method")); ?></th>
                     <th><?php echo e(__("message.Paid Amount")); ?></th>
                     <th><?php echo e(__("message.More")); ?></th>
                     <th><?php echo e(__("message.Print")); ?></th>
                     <th><?php echo e(__("message.Status")); ?></th>
                     <th><?php echo e(__("message.Action")); ?></th>
                  </tfoot>
               </table>
            </div>
         </div>
      </div>
   </div>
</div>
<div class="modal fade" id="normalmodal" tabindex="-1" aria-labelledby="normalmodal" style="display: none;" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="normalmodal1"><?php echo e(__("message.Order No")); ?> : <span id="order_no">5</span></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> <span aria-hidden="true">×</span> </button> 
         </div>
         <div class="modal-body">
            <div style="margin-bottom: 10px;">
                 <p><b><?php echo e(__("message.Name")); ?> :</b> <span id="customer_name"></span></p>
                 <p><b><?php echo e(__("message.email")); ?> :</b> <span id="email"></span></p>
                 <p><b><?php echo e(__("message.Address")); ?> :</b> <span id="address"></span></p>
                 <p><b><?php echo e(__("message.Order Place Date")); ?> :</b> <span id="order_place_date"> </span></p>
                 <p><b><?php echo e(__("message.Payment Method")); ?> :</b> <span id="payment_method"> </span></p>
                 <p><b><?php echo e(__("message.Sample Collection Date")); ?> :</b> <span id="date"> </span></p>
                 <p><b><?php echo e(__("message.Sample Collection time")); ?> :</b> <span id="time"> </span></p>
            </div>
            <table class="table">
                 <thead>
                     <tr>
                        <td><?php echo e(__("message.Person Info")); ?></td>
                        <td><?php echo e(__("message.Item Info")); ?></td>
                        <td><?php echo e(__("message.Price")); ?></td>
                     </tr>
                 </thead>
                 <tbody id="tableinfo">
                    
                 </tbody>
                 <tfoot>
                     <tr>
                        <td></td>
                        <th><?php echo e(__("message.Subtotal")); ?></th>
                        <td id="subtotal"></td>
                    </tr>
                    <tr>
                        <td></td>
                        <th><?php echo e(__("message.Txt Charges")); ?></th>
                        <td id="txt_charge"></td>
                    </tr>
                    <tr>
                        <td></td>
                        <th><?php echo e(__("message.Total")); ?></th>
                        <th id="total"></th>
                    </tr>
                 </tfoot>

            </table>
         </div>
         <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__("message.Close")); ?></button>
         </div>
      </div>
   </div>
</div>

<div class="modal fade" id="reject_order" tabindex="-1" aria-labelledby="normalmodal" style="display: none;" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="normalmodal1"><?php echo e(__("message.Add Reject Description")); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> <span aria-hidden="true">×</span> </button> 
         </div>
         <form method="get" id="rejectorderurl" action="#">

         <div class="modal-body">
             
               <div class="form-group">
                        <label for="name"><?php echo e(__("message.Description")); ?><span class="reqfield">*</span></label>
                       <textarea class="form-control" name="reject_description" id="reject_description" required="" ></textarea>
                     </div>
              
              <p id="calculatetime" style="display: flex;justify-content: center;    margin-top: 20px;"></p>
              <div class="row">
                        
                     </div>
                   
         </div>
         <div class="modal-footer">
                                  
                           <input type="submit" value='<?php echo e(__("message.Send")); ?>' class="btn btn-primary ">
                       
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__("message.Close")); ?></button>
         </div>
          </form>
      </div>
   </div>
</div>

<div class="modal fade" id="complete_order" tabindex="-1" aria-labelledby="normalmodal" style="display: none;" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="normalmodal1"><?php echo e(__("message.Complete Order")); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> <span aria-hidden="true">×</span> </button> 
         </div>
         <form method="post" action="<?php echo e(route('complete-order')); ?>" id="completeorderurl
         " enctype="multipart/form-data">
               <?php echo e(csrf_field()); ?>

               <input type="hidden" name="id" id="com_order_id">
         <div class="modal-body">             
               <div class="form-group">
                  <label for="name"><?php echo e(__("message.Upload Report")); ?><span class="reqfield">*</span></label>
                   <input type="file" name="report" required="" class="form-control" id="report" />
                     </div>
              <p id="calculatetime" style="display: flex;justify-content: center;    margin-top: 20px;"></p>
              <div class="row">
             </div>
         </div>
         <div class="modal-footer">
          <input type="submit" value='<?php echo e(__("message.Send")); ?>' class="btn btn-primary">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__("message.Close")); ?></button>
         </div>
          </form>
      </div>
   </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('manager.layout.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/freakd1c/public_html/demo/laboratory/resources/views/manager/order/default.blade.php ENDPATH**/ ?>