@extends('front.layout')
@section('title')
  {{__('message.Popular Package List')}}
@stop
@section('meta-data')
<meta property="og:type" content="website"/>
<meta property="og:url" content="{{route('show-package-list')}}"/>
<meta property="og:title" content="{{__('message.Popular Package List')}}"/>
<meta property="og:image" content="{{asset('public/img/').'/'.$setting->logo}}"/>
<meta property="og:image:width" content="250px"/>
<meta property="og:image:height" content="250px"/>
<meta property="og:site_name" content="{{__('message.site_name')}}"/>
<meta property="og:description" content="{{__('message.meta_description')}}"/>
<meta property="og:keyword" content="{{__('message.meta_keyword')}}"/>
<link rel="shortcut icon" href="{{asset('public/img/').'/'.$setting->favicon}}">
<meta name="viewport" content="width=device-width, initial-scale=1">
@stop
@section('content')
<section class="page-title-two">
            <div class="title-box centred bg-color-2">
                <div class="pattern-layer">
                   <?php 
                          $sharp70 = asset('public/front/Docpro/assets/images/shape/shape-70.png');
                          $sharp71 = asset('public/front/Docpro/assets/images/shape/shape-71.png');
                    ?>
                    <div class="pattern-1" style="background-image: url('{{$sharp70}}');"></div>
                    <div class="pattern-2" style="background-image: url('{{$sharp71}}');"></div>
                </div>
                <div class="auto-container">
                    <div class="title">
                        <h1>Popular Package List</h1>
                    </div>
                </div>
            </div>
            <div class="lower-content">
                <div class="auto-container">
                    <ul class="bread-crumb clearfix">
                        <li><a href="{{route('home')}}">{{__('message.Home')}}</a></li>
                        <li>{{__('message.Popular Package List')}}</li>
                    </ul>
                </div>
            </div>
        </section>
 <section class="pricing-section bg-color-3 sec-pad">
            <div class="pattern-layer">
               <?php 
                  $path1 = asset('public/front/Docpro/assets/images/shape/shape-39.png');
                  $path2 = asset('public/front/Docpro/assets/images/shape/shape-42.png');
                  $arrow1 = asset('public/front/Docpro/assets/images/icons/arrow-1.png');
                  $sharp45 = asset('public/front/Docpro/assets/images/shape/shape-45.png');
                  $sharp46 = asset('public/front/Docpro/assets/images/shape/shape-46.png');
                   $sharp75 = asset('public/front/Docpro/assets/images/shape/shape-75.png');
                     $sharp76 = asset('public/front/Docpro/assets/images/shape/shape-76.png');
                     $sharp77 = asset('public/front/Docpro/assets/images/shape/shape-77.png');
                  ?>
               <div class="pattern-1" style="background-image: url('{{$path1}}');"></div>
               <div class="pattern-4" style="background-image: url('{{$path2}}');"></div>
            </div>
            <div class="auto-container">
              
               <div class="inner-content">
                  <div class="row clearfix">
                     
                          @foreach($popular_package as $pl)
                           <?php $discount = 100 * ($pl->mrp - $pl->price) / $pl->mrp; ?>
                           <div class="col-lg-4 col-md-6 col-sm-12 pricing-block">
                           <div class="pricing-block-one">
                              <div class="pricing-table">

                                 <div class="pattern">
                                     <span class="discount" >{{round($discount)}} %</span>
                                    <div class="pattern-1" style="background-image: url('{{$sharp75}}');"></div>
                                    <div class="pattern-2" style="background-image: url('{{$sharp76}}');"></div>
                                    <div class="pattern-3" style="background-image: url('{{$sharp77}}');"></div>
                                 </div>
                                 <div class="table-header">
                                    <h2>{{$pl->name}}</h2>
                                        
                                    <h3><span style="text-decoration: line-through;">${{$pl->mrp}}</span> / ${{$pl->price}} </h3>
                                    <p><span>{{__('message.Includes')}} :  </span> {{$pl->no_of_parameter}} {{__('message.Parameters')}} </p>
                                 </div>
                                 <div class="table-content">
                                    <ul class="list clearfix" style="height: 150px;">
                                       <?php $arr = explode("#",$pl->paramater_data);?>
                                       @foreach($arr as $a)
                                         <li>{{$a}}</li>
                                       @endforeach
                                    </ul>
                                 </div>
                                 <div class="table-footer">
                                    @if($pl->type==1)
                                    <div class="link"><a href="{{ route('package-detail', ['id' => $pl->type_id ]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('package-detail', ['id' => $pl->type_id ]) }}" class="theme-btn-one">{{__('message.Know More')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                                    @if($pl->type==2)
                                    <div class="link"><a href="{{ route('parameter-detail', ['id' => $pl->type_id ]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('parameter-detail', ['id' => $pl->type_id ]) }}" class="theme-btn-one">{{__('message.Know More')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                                    @if($pl->type==3)
                                    <div class="link"><a href="{{ route('profile-detail', ['id' => $pl->type_id ]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('profile-detail', ['id' => $pl->type_id ]) }}" class="theme-btn-one">{{__('message.Know More')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                                    
                                 </div>
                              </div>
                           </div>
                        </div>
                           @endforeach
                    
                  </div>
               </div>
            </div>
         </section>
@stop
@section('footer')
@stop