@extends('front.layout')
@section('title')
 {{__('message.Category List')}}
@stop
@section('meta-data')
<meta property="og:type" content="website"/>
<meta property="og:url" content="{{route('category-list')}}"/>
<meta property="og:title" content="{{__('message.site_name')}}"/>
<meta property="og:image" content="{{asset('public/img/').'/'.$setting->logo}}"/>
<meta property="og:image:width" content="250px"/>
<meta property="og:image:height" content="250px"/>
<meta property="og:site_name" content="{{__('message.site_name')}}"/>
<meta property="og:description" content="{{__('message.meta_description')}}"/>
<meta property="og:keyword" content="{{__('message.meta_keyword')}}"/>
<link rel="shortcut icon" href="{{asset('public/img/').'/'.$setting->favicon}}">
<meta name="viewport" content="width=device-width, initial-scale=1">
@stop
@section('content')
<section class="page-title-two">
            <div class="title-box centred bg-color-2">
                <div class="pattern-layer">
                   <?php 
                          $sharp70 = asset('public/front/Docpro/assets/images/shape/shape-70.png');
                          $sharp71 = asset('public/front/Docpro/assets/images/shape/shape-71.png');
                    ?>
                    <div class="pattern-1" style="background-image: url('{{$sharp70}}');"></div>
                    <div class="pattern-2" style="background-image: url('{{$sharp71}}');"></div>
                </div>
                <div class="auto-container">
                    <div class="title">
                        <h1>{{__('message.Browse by')}} {{__('message.Category')}}</h1>
                    </div>
                </div>
            </div>
            <div class="lower-content">
                <div class="auto-container">
                    <ul class="bread-crumb clearfix">
                        <li><a href="{{route('home')}}">{{__('message.Home')}}</a></li>
                        <li>{{__('message.Browse by')}}  {{__('message.Category')}}</li>
                    </ul>
                </div>
            </div>
        </section>
 <section class="centred sec-pad">
            <div class="pattern-layer">
               <?php 
                  $path1 = asset('public/front/Docpro/assets/images/shape/shape-39.png');
                  $path2 = asset('public/front/Docpro/assets/images/shape/shape-42.png');
                  $arrow1 = asset('public/front/Docpro/assets/images/icons/arrow-1.png');
                  $sharp45 = asset('public/front/Docpro/assets/images/shape/shape-45.png');
                  $sharp46 = asset('public/front/Docpro/assets/images/shape/shape-46.png');
                  ?>
               <div class="pattern-1" style="background-image: url('{{$path1}}');"></div>
               <div class="pattern-4" style="background-image: url('{{$path2}}');"></div>
            </div>
            <div class="auto-container">
              
               <div class="inner-content">
                  <div class="row clearfix">
                        @foreach($subcategory as $c)
                           <div class="col-lg-3 col-md-6 col-sm-12 category-block">
                              <div class="category-block-one wow fadeInUp animated animated" data-wow-delay="00ms" data-wow-duration="1500ms">
                                 <div class="inner-box">
                                    <div class="pattern">
                                       <div class="pattern-1" style="background-image: url('{{$sharp45}}');"></div>
                                       <div class="pattern-2" style="background-image: url('{{$sharp46}}');"></div>
                                    </div>
                                    <figure class="icon-box"><img src="{{asset('storage/app/public/Subcategory').'/'.$c->image}}" alt=""></figure>
                                    <h3><a href="{{ route('subcategory-detail', ['id' => $c->id]) }}">{{$c->name}}</a></h3>
                                    <span>{{$c->short_desc}}</span>
                                    <div class="link"><a href="{{ route('subcategory-detail', ['id' => $c->id]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('subcategory-detail', ['id' => $c->id]) }}" class="theme-btn-one">{{__('message.View Detail')}}<i class="icon-Arrow-Right"></i></a></div>
                                 </div>
                              </div>
                           </div>
                      
                        @endforeach
                    
                  </div>
               </div>
            </div>
         </section>
@stop
@section('footer')
@stop