<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\City;
use App\Models\FamilyMember;
use App\Models\UserAddress;
use App\Models\Orders;
use DataTables;
use Session;
class UserController extends Controller
{
    //

    public function show_manager(){
        return view("admin.manager.default");
    }

    public function show_ManagerTable(){
        $user =User::whereNull('deleted_at')->where("user_type",'2')->get();
         return DataTables::of($user)
            ->editColumn('id', function ($user) {
                return $user->id;
            })
            ->editColumn('name', function ($user) {
                return $user->name;
            })
            ->editColumn('email', function ($user) {
                return $user->email;
            })
            ->editColumn('city', function ($user) {
                return City::find($user->city)?City::find($user->city)->name:'';
            })
            ->editColumn('image', function ($user) {
                return url("storage/app/public/profile")."/".$user->profile_pic;
            })      
            ->editColumn('action', function ($user) {
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete');
                $edit = url('savemanager',array('id'=>$user->id));
                $delete = url('deleteuser',array('id'=>$user->id));
                return '<a  href="'.$edit.'" rel="tooltip"  class="btn btn-primary" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';              
            })           
            ->make(true);
    }

    public function show_savemanager($id){
        $data = User::find($id);
        $city = City::where("is_deleted",'0')->get();
        return view("admin.manager.save")->with("data",$data)->with("id",$id)->with("city",$city);
    }

    public function show_update_manager_profile(Request $request){
        // dd($request->all());
       
        if($request->get("id")==0){
                $getmanager = User::where("email",$request->get("email"))->first();
                if($getmanager){
                    // Session::flash('message',"Email Already Exist"); 
                    Session::flash('message',__('message.Email Already Exist'));
                    Session::flash('alert-class', 'alert-danger');
                    return redirect()->back();
                }
                 $store = new User();
        }else{
                $getmanager = User::where("email",$request->get("email"))->where("id","!=",$request->get("id"))->first();
                if($getmanager){
                    
                    // Session::flash('message',"Email Already Exist");
                    Session::flash('message',__('message.Email Already Exist')); 
                    Session::flash('alert-class', 'alert-danger');
                    return redirect()->back();
                }
                $store = User::find($request->get("id"));
                
        }       
        $store->name = $request->get("name");
        $store->email = $request->get("email");
        $store->password = $request->get("password");
        $store->city = $request->get("city");
        $store->user_type = '2';
        if($request->file("upload_image")){
            if($store->profile_pic!=""){
                $this->removeImage('profile/' . $store->profile_pic);
            }             
            $store->profile_pic = $this->fileuploadFileImage($request,'profile','upload_image');
        }        
        $store->save();
        // Session::flash('message',"Profile Save Successfully");
        Session::flash('message',__('message.Profile Save Successfully'));  
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('manager');
    }

    public function deleteuser($id){
        $user = User::find($id);
        if($user){
            $user->delete();
        }
        // Session::flash('message',"Manager delete Successfully"); 
        Session::flash('message',__('message.Manager delete Successfully'));  
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('manager');
    }


    public function show_user(){
        return view("admin.manager.user");
    }


    public function show_UserTable(){
        $user =User::whereNull('deleted_at')->where("user_type",'3')->get();
         return DataTables::of($user)
            ->editColumn('id', function ($user) {
                return $user->id;
            })
            ->editColumn('name', function ($user) {
                return $user->name;
            })
            ->editColumn('email', function ($user) {
                return $user->email;
            })
            ->editColumn('city', function ($user) {
                // return City::find($user->city)?City::find($user->city)->name:'';
                $memertext = __('message.Members');
                 return '<a href="javascript:void(0)" onclick="view_member(' . "'" .$user->id. "'" . ')" data-bs-toggle="modal" data-bs-target="#normalmodal" rel="tooltip"  class="btn btn-info" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$memertext.'</a>';
            })
            ->editColumn('member', function ($user) {
            
            $addresstext =__('message.Address');
                return '<a href="javascript:void(0)" onclick="view_address(' . "'" .$user->id. "'" . ')" data-bs-toggle="modal" data-bs-target="#addressmodal" rel="tooltip"  class="btn btn-info" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$addresstext.'</a>';

            })
            ->editColumn('image', function ($user) {
                if($user->profile_pic != "")
                {
                    return url("storage/app/public/profile")."/".$user->profile_pic;
                }
                else
                {
                    return url("public/img")."/default_user.png";
                }
            })      
            ->editColumn('action', function ($user) {
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete');
                $edit = url('savemanager',array('id'=>$user->id));
                $delete = url('deleteuser_detail',array('id'=>$user->id));
                return '<a onclick="delete_user_detail(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';              
            })    
             ->escapeColumns([])       
            ->make(true);
    }

    public function deleteuser_detail($id){
        $user = User::find($id);
        $familt_data=FamilyMember::where('user_id',$id)->get();
        $add_data=UserAddress::where('user_id',$id)->get();
        $order_data=Orders::where('user_id',$id)->get();

        if($user)
        {
            // $user->delete();
            foreach ($familt_data as $k) {
                $k->delete();
            }
            foreach ($add_data as $j) {
                $j->delete();
            }
            foreach ($order_data as $b) {
                $b->delete();
            }
            $user->delete();
        }
        // Session::flash('message',"User delete Successfully");
        Session::flash('message',__('message.User delete Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('user'); 
        
    }


    public function getmembersinfo($id)
    {
      $data=FamilyMember::where('user_id',$id)->get();
      $data_new=array("item_list"=>$data);     
      return $data_new;
    }
   public function getaddress($id)
    {

      $data=UserAddress::where('user_id',$id)->get();
     /* echo "<pre>";
      print_r($data);
      die(); */
      $data_new=array("item_list"=>$data);     
      return $data_new;
      
   }


}
