<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\City;
use App\Models\Category;
use App\Models\Subcategory;
use App\Models\Package;
use App\Models\Parameter;
use App\Models\Package_FRQ;
use App\Models\TestDetails;
use App\Models\Popular_package;
use App\Models\Profiles;
use App\Models\FamilyMember;
use App\Models\CartMember;
use App\Models\UserAddress;
use App\Models\Setting;
use App\Models\PaymentGateway;
use App\Models\Orders;
use App\Models\OrdersData;
use App\Models\Contactus;
use App\Models\News;
use App\Models\Token;
use App\Models\Review;
use App\Models\Feedback;
use App\Models\Resetpassword;
use App\Models\About;
use Illuminate\Support\Facades\Session;
use Auth;
use Cart;
use DB;
use Illuminate\Support\Facades\Hash;
use Mail;
class FrontController extends Controller
{

    public function __construct(){
        
    }

    public function show_home(){
        $category = Subcategory::where('is_deleted','0')->get();
        $popular_package = Popular_package::whereNull('deleted_at')->orderby("id","DESC")->get();
        $data_popular = Popular_package::whereNull('deleted_at')->orderby("id","DESC")->take(6)->get();
        foreach ($data_popular as $p) {
            if($p->type==1){ //package
                $ls = array();
                $pa_data = Package::find($p->type_id);
                $find_pa = TestDetails::where("package_id",$p->type_id)->get();
                $parameter = 0;
                foreach($find_pa as $d){
                    if($d->type==1){
                        $ls[] = Parameter::find($d->type_id)?Parameter::find($d->type_id)->name:'';
                        $parameter = $parameter+1;
                    }
                    if($d->type==2){
                        $a = Profiles::find($d->type_id);
                        $ls[] = Profiles::find($d->type_id)?Profiles::find($d->type_id)->profile_name:'';
                        $parameter = $parameter+1;
                            // $arr = explode(",",$a->no_of_parameter);
                            // foreach($arr as $l){
                            //     $ls[] = Parameter::find($l)?Parameter::find($l)->name:'';
                            // }
                            // $parameter = $parameter+count($arr);
                        
                    }
                }

                $p->no_of_parameter = $parameter;
                $p->paramater_data = implode("#",array_slice($ls, 0, 4));
                $p->mrp = $pa_data->mrp;
                $p->price = $pa_data->price;
            }else if($p->type==2){ //parameters
              $p->paramater_data = Parameter::find($p->type_id)?Parameter::find($p->type_id)->name:'';
              $p->no_of_parameter = 1;
              $p->mrp = Parameter::find($p->type_id)?Parameter::find($p->type_id)->mrp:'';
              $p->price = Parameter::find($p->type_id)?Parameter::find($p->type_id)->price:'';
            }else{ //profiles
                $data = Profiles::find($p->type_id);                
                $ls = array();
                if($data){
                    $arr = explode(",",$data->no_of_parameter);                    
                    $i=0;
                    foreach($arr as $a){
                        if($i<=3){
                            $ls[] = Parameter::find($a)?Parameter::find($a)->name:'';
                        }$i++;                        
                    }
                    $p->paramater_data = implode("#",$ls);
                    $p->no_of_parameter = count($arr);
                }
                
                $p->mrp = Profiles::find($p->type_id)?Profiles::find($p->type_id)->mrp:'';
                $p->price = Profiles::find($p->type_id)?Profiles::find($p->type_id)->price:'';
            }
        }
        
        $setting = Setting::find(1);
        $data_feedback = Feedback::with('userdata')->orderby('id','DESC')->get();
        Session::put("active_menu","1");
        return view("front.home")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("data_popular",$data_popular)->with("data_feedback",$data_feedback)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function save_contact_detail(Request $request){
        $store = new Contactus();
        $store->name = $request->get("name");
        $store->email = $request->get("email");
        $store->phone = $request->get("phone");
        $store->subject = $request->get("subject");
        $store->message = $request->get("message");
        $store->save();
        Session::flash('message',__('message.Connect To You Very Soon'));
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    public function show_post_user_feedback(Request $request){
        $store = new Feedback();
        $store->user_id = Auth::id();
        $store->order_id = $request->get("order_id");
        $store->description = $request->get("description");
        $store->date = $this->getsitedate();
        $store->save();
        Session::flash('message',__('message.Thanks For Your Feedback'));
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    public function getallpack(){
        $data1 = Package::whereNull('deleted_at')->get();
        $data2 = Profiles::whereNull('deleted_at')->get();
        $data3 = Parameter::whereNull('deleted_at')->get();
        $ls = array();
        foreach($data1 as $d1){
            $a = array();
            $a['id'] = $d1->id;
            $a['name'] = $d1->name;
            $ls[] = $a;
        }
        foreach($data2 as $d1){
            $a = array();
            $a['id'] = $d1->id;
            $a['name'] = $d1->profile_name;
            $ls[] = $a;
        }
        foreach($data3 as $d1){
            $a = array();
            $a['id'] = $d1->id;
            $a['name'] = $d1->name;
            $ls[] = $a;
        }
        return json_encode($ls);
    }

    public function show_search_item(Request $request){
        //dd($request->all());
        $tags = $request->get("tags");
        $data1 = Package::whereNull('deleted_at')->Where('name',$tags)->first();
        if($data1){
            return redirect("package_detail".'/'.$data1->id);
        }
        $data2 = Profiles::whereNull('deleted_at')->Where('profile_name',$tags)->first();
        if($data2){
            return redirect("profile_detail?id=".$data2->id);
        }
        $data3 = Parameter::whereNull('deleted_at')->Where('name',$tags)->first();
        if($data3){
            return redirect("parameter-detail?id=".$data3->id);
        }
        // return redirect()->route('user-login');
        return redirect()->back();
    }

    public function addnewsletter($email){
        $store = new News();
        $store->email = $email;
        $store->save();
        return 1;
    }

    public function show_postreview(Request $request){
        $data = new Review();
        $data->user_id = Auth::id();
        $data->type = $request->get("type");
        $data->type_id = $request->get("type_id");
        $data->ratting = $request->get("rating");
        $data->description = $request->get("description");
        $data->date = $this->getsitedate();
        $data->save();
        Session::flash('message',__('message.Review Record Successfully'));
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    public function show_categorylist(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $subcategory = Subcategory::where('is_deleted','0')->get();
        Session::put("active_menu","5");
        $setting = Setting::find(1);
        return view("front.category_list")->with("category",$category)->with("subcategory",$subcategory)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }


    public function show_package_list(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();        
        $setting = Setting::find(1);
          foreach ($popular_package as $p) {
            if($p->type==1){ //package
                $ls = array();
                $pa_data = Package::find($p->type_id);
                $find_pa = TestDetails::where("package_id",$p->type_id)->get();
                $parameter = 0;
                foreach($find_pa as $d){
                    if($d->type==1){
                        $ls[] = Parameter::find($d->package_id)?Parameter::find($d->package_id)->name:'';
                        $parameter = $parameter+1;
                    }
                    if($d->type==2){
                        $a = Profiles::find($d->package_id);
                        if($a){
                            $arr = explode(",",$a->no_of_parameter);
                            foreach($arr as $l){
                                $ls[] = Parameter::find($l)?Parameter::find($l)->name:'';
                            }
                            $parameter = $parameter+count($arr);
                        }
                    }
                }

                $p->no_of_parameter = $parameter;
                $p->paramater_data = implode("#",array_slice($ls, 0, 4));
                $p->mrp = $pa_data->mrp;
                $p->price = $pa_data->price;
            }else if($p->type==2){ //parameters
              $p->paramater_data = Parameter::find($p->type_id)?Parameter::find($p->type_id)->name:'';
              $p->no_of_parameter = 1;
              $p->mrp = Parameter::find($p->type_id)?Parameter::find($p->type_id)->mrp:'';
              $p->price = Parameter::find($p->type_id)?Parameter::find($p->type_id)->price:'';
            }else{ //profiles
                $data = Profiles::find($p->type_id);                
                $ls = array();
                if($data){
                    $arr = explode(",",$data->no_of_parameter);                    
                    $i=0;
                    foreach($arr as $a){
                        if($i<=3){
                            $ls[] = Parameter::find($a)?Parameter::find($a)->name:'';
                        }$i++;                        
                    }
                    $p->paramater_data = implode("#",$ls);
                    $p->no_of_parameter = count($arr);
                }
                
                $p->mrp = Profiles::find($p->type_id)?Profiles::find($p->type_id)->mrp:'';
                $p->price = Profiles::find($p->type_id)?Profiles::find($p->type_id)->price:'';
            }
        }
        Session::put("active_menu","4");
        return view("front.package_list")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_subcategory_detail($id){
        $category = Category::where('is_deleted','0')->get();
        $subcategory = Subcategory::find($id);
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $package_list = Package::where("category_id",$id)->whereNull('deleted_at')->get();
        $profile_list = Profiles::where("category_id",$id)->whereNull('deleted_at')->get();
        $parameter_list = Parameter::where("category_id",$id)->whereNull('deleted_at')->get();
        $setting = Setting::find(1);
        
                    $data1 = Package::where("category_id",$id)->whereNull('deleted_at')->get();
                    $data2 = Profiles::where("category_id",$id)->whereNull('deleted_at')->get();
                    $data3 = Parameter::where("category_id",$id)->whereNull('deleted_at')->get();
                    
                    $package = array();
                    $perameter = array();
                    $profile = array();
                    
                    foreach($data1 as $d1){
                        $find_pa = TestDetails::where("package_id",$d1->id)->get();
                        $parameter = 0;
                        $ls1 = array();
                        foreach($find_pa as $d){
                            if($d->type==1){
                                $ls1[] = Parameter::whereNull('deleted_at')->find($d->type_id)?Parameter::find($d->type_id)->name:'';
                                $parameter = $parameter+1;
                            }
                           
                            if($d->type==2){
                                $a = Profiles::find($d->type_id);
                                
                                    $ls1[] = Profiles::whereNull('deleted_at')->find($d->type_id)?Profiles::find($d->type_id)->profile_name:'';
                                    $parameter = $parameter+1;
                                
                            }
                        }
                        // echo "<pre>";
                        // print_r($ls1);exit;
                        $a = array();
                        $a['id'] = $d1->id;
                        $a['name'] = $d1->name;
                        $a['mrp'] = number_format($d1->mrp,2,'.','');
                        $a['price'] = number_format($d1->price,2,'.','');
                        $total = 100 * ($d1->mrp - $d1->price) / $d1->mrp;
                        $a['discount'] = number_format($total,'2','.','');
                        $a['type'] = '1';
                        $a['no_of_parameter'] = $parameter;
                        $a['parameter_list'] = $ls1;
                        $package[] = $a;
                    }
                    foreach($data3 as $d1){
                        $a = array();
                        $a['id'] = $d1->id;
                        $a['name'] = $d1->name;
                        $a['mrp'] = number_format($d1->mrp,2,'.','');
                        $a['price'] = number_format($d1->price,2,'.','');
                        $total = 100 * ($d1->mrp - $d1->price) / $d1->mrp;
                        $a['discount'] = number_format($total,'2','.','');
                        $a['type'] = '2';
                        $a['no_of_parameter'] = 1;
                        $a['parameter_list'] = array($d1->name);                        
                        $perameter[] = $a;                        
                    }
                    foreach($data2 as $d1){

                        $arr = explode(",",$d1->no_of_parameter);                    
                        $i=0;
                        $ls1 = array();
                        foreach($arr as $a){
                            if($i<=3){
                                $ls1[] = Parameter::find($a)?Parameter::find($a)->name:'';
                            }$i++;                        
                        }
                        
                        $a = array();
                        $a['id'] = $d1->id;
                        $a['name'] = $d1->profile_name;
                        $a['mrp'] = number_format($d1->mrp,2,'.','');
                        $a['price'] = number_format($d1->price,2,'.','');
                        $total = 100 * ($d1->mrp - $d1->price) / $d1->mrp;
                        $a['discount'] = number_format($total,'2','.','');
                        $a['type'] = '3';
                        $a['no_of_parameter'] = count($arr);
                        $a['parameter_list'] = $ls1;
                        $profile[] = $a;

                    }
                    $totalcartmember = $this->gettotalcartmember();
                    
        // echo "<pre>";
        // print_r($package_list);exit;
        Session::put("active_menu","5");
        return view("front.subcategory_list",compact('package','perameter','profile','category','subcategory','popular_package','setting','package_list','totalcartmember'));
    }

    public function show_checkout(){
        $cart = CartMember::where("user_id",Auth::id())->get();
       
        if(count($cart) < 0){
            return redirect()->route('home');
        }
        if(empty(Auth::id())){
            return redirect()->route('home');
        }
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $getfamilymemenber = FamilyMember::where("user_id",Auth::id())->get();
        $cartmember = CartMember::with('family_member_data')->where("user_id",Auth::id())->get();
        foreach($getfamilymemenber as $g){
            $store = CartMember::where("family_member_id",$g->id)->where("user_id",Auth::id())->first();
            if($store){
                $g->cartmember = '1';
            }else{
                $g->cartmember = '0';
            }
        }
        $setting = Setting::find(1);
        $getcurrency = explode("-",$setting->currency);
        $useraddress = UserAddress::where("user_id",Auth::id())->get();
        $getallkeys = PaymentGateway::all();
        $getcity = City::where("is_deleted",'0')->get();
        $ls = array();
        foreach($getallkeys as $g){
            $ls[$g->payment_gateway_name."_".$g->key_name] = $g->meta_value;
        }
        $ls1 = $this->getcartcontent();
    //   echo "<pre>";print_r($ls1);exit;
        $clientToken = "";
         if($ls['Braintree_is_active']=='1'){
                $gateway = new \Braintree\Gateway([
                    'environment' => $ls['Braintree_environment'],
                    'merchantId' => $ls['Braintree_merchantId'],
                    'publicKey' => $ls['Braintree_publicKey'],
                    'privateKey' => $ls['Braintree_privateKey']
                ]);
                $clientToken = $gateway->clientToken()->generate();
         } 
         Session::put("active_menu","");
         $currency = $getcurrency[1];
        //  echo"<pre>";
        //  print_r($getcurrency[1]);
        //  exit();
        return view("front.checkout")->with("category",$category)->with("popular_package",$popular_package)->with("getfamilymemenber",$getfamilymemenber)->with("cartmember",$cartmember)->with("useraddress",$useraddress)->with("setting",$setting)->with("currency",$currency)->with("token",$clientToken)->with("paymentkeys",$ls)->with("city",$getcity)->with("totalcartmember",$this->gettotalcartmember())->with("cartdata",$ls1);

    }

    public function show_update_user_family(Request $request){
        
        $this->validate($request,[
          'name' =>'required',
          'phone' => 'required',
          'email' => 'required',
          'age' => 'required',
          'dob' => 'required',
          'relation' => 'required',
          'gender' => 'required',
        ]);
       
        if($request->get("id")!=""){
            $store = FamilyMember::find($request->get("id"));
            // $msg = "Member Update Successfully";
            $msg = __('message.Member Update Successfully');
        }else{
            $store = new FamilyMember();
            // $msg = "Member Add Successfully";
            $msg = __('message.Member Add Successfully');
        }
          
          $store->name = $request->get("name");
          $store->mobile_no = $request->get("phone");
          $store->age = $request->get("age");
          $store->email = $request->get("email");
          $store->dob = $request->get("dob");
          $store->relation = $request->get("relation");
          $store->gender = $request->get("gender");
          $store->user_id = Auth::id();
          $store->save();
          Session::flash('message',$msg); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }

    public function deletememer($id)
    {
        $store = FamilyMember::find($id);
        if($store){
            $store->delete();
        }
        // Session::flash('message',"Member Delete Successfully"); 
        Session::flash('message',__('message.Member Delete Successfully'));
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    function deleteaddress($id){
        $store = UserAddress::find($id);
        if($store){
            $store->delete();
        }
        // Session::flash('message',"Address Delete Successfully"); 
        Session::flash('message',__('message.Address Delete Successfully'));
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    public function show_getmember(Request $request){
        return json_encode(FamilyMember::where("id",$request->get("id"))->where("user_id",Auth::id())->first());
    }

    public function show_post_user_address(Request $request){        
        if($request->get("id")!=""){
            $store = UserAddress::find($request->get("id"));
            // $msg = "User Address Update Successfully";
             $msg = __('message.User Address Update Successfully');
        }else{
            $store = new UserAddress();
            // $msg = "User Address Add Successfully";
            $msg = __('message.User Address Add Successfully');
        }
        $store->user_id = Auth::id();
        $store->name = $request->get("name");
        $store->house_no = $request->get("house_no");
        $store->pincode = $request->get("pincode");
        $store->city = $request->get("city");
        $store->state = $request->get("state");
        if($request->get("is_default") == ""){
             $store->is_default = 0;
        }else{
            $store->is_default = $request->get("is_default");
        }
        
        $store->address = $request->get("address");
        $store->lat = $request->get("lat");
        $store->long = $request->get("long");
        $store->save();
        Session::flash('message',$msg); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }

    public function show_update_user_member(Request $request){
        $user = User::find(Auth::id());
        if($user){
            $store = new FamilyMember();
          $store->name = $request->get("name");
          $store->mobile_no = $request->get("phone");
          $store->age = $request->get("age");
          $store->email = $request->get("email");
          $store->dob = $request->get("dob");
          $store->relation = $request->get("relation");
          $store->gender = $request->get("gender");
          $store->user_id = Auth::id();
          $store->save();
          return $store->id;
             
        }else{
          return redirect()->route('user-login');
        }
    }

    public function show_user_logout(){
        Auth::logout();
        return redirect()->route('home');
    }

    public function show_login(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        Session::put("active_menu","");

        session(['previous_url' => url()->previous()]);

        return view("front.login")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_aboutus(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        $data=About::find(1);
        Session::put("active_menu","2");
        return view("front.aboutus")->with("data",$data)->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_forgotpassword(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        Session::put("active_menu","2");
        return view("front.forgotpassword")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function post_forgotpassword(Request $request){
        $getuser = User::where("email",$request->get("email"))->where("user_type",'3')->first();
        if($getuser){
                          $code=mt_rand(100000, 999999);
                          $store=array();
                          $store['email']=$getuser->email;
                          $store['name']=$getuser->name;
                          $store['code']=$code;
                          $reset  = new Resetpassword();
                          $reset->code = $code;
                          $reset->user_id = Auth::id();
                          $reset->save();
                          try {
                                  Mail::send('email.forgotpassword', ['user' => $store], function($message) use ($store){
                                    $message->to($store['email'],$store['name'])->subject(__("message.site_name"));
                                });
                          } catch (\Exception $e) {
                          }
                            // Session::flash('message',"Mail Send Successfully");
                            Session::flash('message',__('message.Mail Send Successfully')); 
                            Session::flash('alert-class', 'alert-success');
                            return redirect()->back();                           
        }else{
                // Session::flash('message',"Email id match with our system");
                Session::flash('message',__('message.Email id match with our system')); 
                Session::flash('alert-class', 'alert-danger');
                return redirect()->back();
        }

    }

    public function resetpassword($code){
            $setting = Setting::find(1);
            $popular_package = Popular_package::whereNull('deleted_at')->get();
            $category = Category::where('is_deleted','0')->get();
            $setting = Setting::find(1);
            $data=Resetpassword::where("code",$code)->first();
            if($data){
              return view('front.resetpwd')->with("id",$data->user_id)->with("code",$code)->with("type",$data->type)->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
            }else{
              return view('front.resetpwd')->with("msg",__('message.Code Expired'))->with("setting",$setting)->with("category",$category)->with("popular_package",$popular_package)->with("totalcartmember",$this->gettotalcartmember());
            }
    }

    public function resetnewpwd(Request $request){
       $setting = Setting::find(1);
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        if($request->get('id')==""){
            return view('front.resetpwd')->with("msg",__('message.pwd_reset'))->with("setting",$setting)->with("category",$category)->with("popular_package",$popular_package)->with("totalcartmember",$this->gettotalcartmember());
        }else{
            if($request->get("type")==1){
                 $user=Patient::find($request->get('id'));
            }else{
                $user=Doctors::find($request->get('id'));
            }
            $user->password=$request->get('npwd');
            $user->save();
            $codedel=Resetpassword::where('user_id',$request->get("id"))->delete();
            return view('front.resetpwd')->with("msg",__('message.pwd_reset'))->with("setting",$setting)->with("category",$category)->with("popular_package",$popular_package)->with("totalcartmember",$this->gettotalcartmember());
        }
    }

    public function show_service(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        Session::put("active_menu","3");
         $data_feedback = Feedback::with('userdata')->orderby('id','DESC')->get();
        return view("front.service")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("data_feedback",$data_feedback)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_contactus(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        Session::put("active_menu","6");
        return view("front.contactus")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_register(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        Session::put("active_menu","");
        return view("front.register")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_changepassword(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        return view("front.changepassword")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function update_change_password(Request $request){
        $store = User::find(Auth::id());
        $store->password = Hash::make($request->get("npassword"));
        $store->save();
        Session::flash('message',__('message.Password Update Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    public function show_user_profile(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        return view("front.myprofile")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_my_addresses(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        $city = City::where("is_deleted",'0')->get();
        $myaddresses = UserAddress::where("user_id",Auth::id())->whereNull('deleted_at')->get();
        return view("front.myaddresses")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("myaddresses",$myaddresses)->with("city",$city)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_my_family_member(){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        $myfamily = FamilyMember::where("user_id",Auth::id())->whereNull('deleted_at')->get();
        return view("front.my_family_member")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("myfamily",$myfamily)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_update_profile_info(Request $request){
        $getusers = User::where("email",$request->get("name"))->where("id","!=",Auth::id())->first();
        
        if($getusers){
            Session::flash('alert-class', 'alert-danger');
            return redirect()->back();
        }
        $store = User::find(Auth::id());
        $store->name = $request->get("name");
        $store->email = $request->get("email");
        if($request->file("upload_image")){
            if(Auth::user()->profile_pic!=""){
                $this->removeImage('profile/' . $store->profile_pic);
            }             
            $store->profile_pic = $this->fileuploadFileImage($request,'profile','upload_image');
        }        
        $store->save();
        
        Session::flash('message',__('message.Profile Update Successfully')); 
        Session::flash('alert-class', 'alert-success');
         return redirect('user_profile');
    }

    public function show_dashboard(Request $request){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        $totalorders = count(Orders::where("user_id",Auth::id())->get());
        $pendingorders = count(Orders::where("user_id",Auth::id())->whereIn("status",array(2,6,5))->get());
        $completeorders = count(Orders::where("user_id",Auth::id())->where("status",'7')->get());
        if($request->get("type")=='past'){
            $type = 1;
            $data = Orders::where("user_id",Auth::id())->where("date","<",date('Y-m-d'))->orderBy('id','desc')->get();
        }
        else if($request->get("type")=='upcomming'){
            $type = 2;
            $data = Orders::where("user_id",Auth::id())->where("date",">",date('Y-m-d'))->orWhereDate("date", "=", date('Y-m-d'))->orderBy('id','desc')->get();
        }
        else{
            $type = 2;
            // $data = Orders::where("user_id",Auth::id())->where("date",date('Y-m-d'))->get();
            $data = Orders::where("user_id",Auth::id())->where("date",">",date('Y-m-d'))->orWhereDate("date", "=", date('Y-m-d'))->orderBy('id','desc')->get();
        }
        foreach($data as $d){
            $d->is_feedback = Feedback::where("order_id",$d->id)->first()?1:0;
        }
        return view("front.dashboard")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalorders",$totalorders)->with("pendingorders",$pendingorders)->with("completeorders",$completeorders)->with("data",$data)->with("type",$type)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function show_printorder(Request $request){
        $data = Orders::with('useraddressdetails')->where("user_id",Auth::id())->where("id",$request->get("id"))->first();
        if($data){
            $data->orderdata = OrdersData::with("memberdetails")->where("order_id",$request->get("id"))->get();
            $popular_package = Popular_package::whereNull('deleted_at')->get();
            $category = Category::where('is_deleted','0')->get();
            $setting = Setting::find(1);
            $getcurrency = explode("-",$setting->currency);
            return view("front.print")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("data",$data)->with("currency",$getcurrency[1]);
        }
        Session::flash('message',"Data Not Found"); 
        Session::flash('alert-class', 'alert-danger');
        return redirect()->back();
        
    }

    public function show_admin_printorder($id){
        $data = Orders::with('useraddressdetails')->where("id",$id)->first();
         
        if($data){
            
            $setting = Setting::find(1);
            $data->orderdata = OrdersData::with("memberdetails")->where("order_id",$id)->get();
            $popular_package = Popular_package::whereNull('deleted_at')->get();
            $category = Category::where('is_deleted','0')->get();
            $setting = Setting::find(1);
            $getcurrency = explode("-",$setting->currency);
            return view("front.print")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("data",$data)->with("currency",$getcurrency[1]);
            $msg = __('message.Order Is Complete');
            $this->send_notification_order_android($setting->android_server_key,$data->user_id,$msg,$data->id);
            $this->send_notification_order_android($setting->ios_server_key,$data->user_id,$msg,$data->id);
            
        }
        // Session::flash('message',"Data Not Found");
        Session::flash('message',__('message.Data Not Found'));  
        Session::flash('alert-class', 'alert-danger');
        return redirect()->back();
    }

    public function show_appointmentbook($id){
        $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
        $setting = Setting::find(1);
        return view("front.appointment_details")->with("category",$category)->with("popular_package",$popular_package)->with("setting",$setting)->with("totalcartmember",$this->gettotalcartmember());
    }

    public function post_user_login(Request $request){
          //  dd($request->all());
                $checkuser=User::where("email",$request->get("email"))->where("user_type",'3')->first();



                if($checkuser){

                    if ($checkuser && Hash::check($request->get('password'), $checkuser->password) || $request->get("password") == $checkuser->password) {
                        Auth::login($checkuser, true);
                    if($request->get("rem_me")==1){
                        setcookie('email', $request->get("email"), time() + (86400 * 30), "/");
                        setcookie('password',$request->get("password"), time() + (86400 * 30), "/");
                        setcookie('remember',1, time() + (86400 * 30), "/");
                    }
                    Session::put('user', $checkuser);
                    // if($request->get("is_checkout")==1){
                    //     return redirect()->route("checkout");
                    // }else{
                    //     return redirect()->route("dashboard");
                    // }
                    $previousUrl = session('previous_url', '/');
                    session()->forget('previous_url');
                    return redirect()->intended($previousUrl)->with('success', 'Login successful');
                    } else {
                        Session::flash('message',__('message.Login credentials are wrong'));
                    Session::flash('alert-class', 'alert-danger');
                    return redirect()->back();
                    }



                }else{
                    Session::flash('message',__('message.Login credentials are wrong'));
                    Session::flash('alert-class', 'alert-danger');
                    return redirect()->back();
                }
    }

    public function post_user_register(Request $request){
            $getuser = User::where("email",$request->get("email"))->where("user_type",'3')->first();
            if($getuser){
                     $msg = __("message.Email Id Already Exist");
                     Session::flash('message',$msg); 
                     Session::flash('alert-class', 'alert-danger');
                     return redirect()->back()->withInput();
            }else{
                $store = new User();
                $store->name = $request->get("name");
                $store->email = $request->get("email");
                $store->password = Hash::make($request->get("password"));
                $store->user_type = '3';
                $store->save();
                // Session::flash('message',"Your Profile Register Successfully");
                Session::flash('message',__('message.Your Profile Register Successfully')); 
                Session::flash('alert-class', 'alert-success');

                Auth::login($store, true);           
                if($request->get("rem_me")==1){
                    setcookie('email', $request->get("email"), time() + (86400 * 30), "/");
                    setcookie('password',$request->get("password"), time() + (86400 * 30), "/");
                    setcookie('remember',1, time() + (86400 * 30), "/");
                }
                Session::put('user', $store);

                return redirect()->route('dashboard');
            }
    }

    public function getorderdetails1($id){
        $data = Orders::with('useraddressdetails')->where("id",$id)->first();
        $address = UserAddress::find($data->sample_collection_address_id);
        if($address){
            $address = $address->address;
        }else{
            $address = "";
        }
        
        if($data){
            $data->orderdata = OrdersData::with("memberdetails")->where("order_id",$id)->get();
            $setting = Setting::find(1);
            $getcurrency = explode("-",$setting->currency);
            $userinfo = User::find($data->user_id);
            $userinfo->address = $address;
            $data1 = array("data"=>$data,"currency"=>$getcurrency[1],"setting"=>$setting,"userinfo"=>$userinfo);
            // echo"<pre>";
            // print_r(json_encode($data));
            // exit();
            return json_encode($data1);
        }
        return 0;
    }

    public function show_package_detail($id){
        $data = Package::find($id);
        Session::put("active_menu","");
        if($data){
                $data->package_frq = Package_FRQ::where("package_id",$id)->where("type",'1')->get();
                $data->testdetails = TestDetails::where("package_id",$id)->get();
                $profiles_list = Profiles::whereNull('deleted_at')->get();
                $parameter_list = Parameter::whereNull('deleted_at')->get();
                $find_pa = TestDetails::where("package_id",$id)->get();
                $parameter = 0;
                foreach($find_pa as $d){
                    if($d->type==1){
                        $parameter = $parameter+1;
                    }
                    if($d->type==2){
                        $a = Profiles::find($d->package_id);
                        if($a){
                            $arr = explode(",",$a->no_of_parameter);
                            $parameter = $parameter+count($arr);
                        }
                    }
                }

                $data->parameter = $parameter;
               // echo $parameter;exit;
                $arr = array();
                if($data->realted_package!=""){
                    $arr = explode(",",$data->realted_package);
                }else{
                    $rel = Package::whereNull('deleted_at')->where("id","!=",$id)->get();
                    foreach($rel as $r){
                        $arr[]=$r->id;
                    }
                }
                 
                 $list_related = array();
                 foreach($arr as $a){
                        $ls = Package::find($a);
                        if($ls){
                            $find_pa = TestDetails::where("package_id",$a)->get();
                        $parameter = 0;
                        $b = array();
                        foreach($find_pa as $d){
                           if($d->type==1){
                                    $b[] = Parameter::find($d->package_id)?Parameter::find($d->package_id)->name:'';
                                    $parameter = $parameter+1;
                                }
                                if($d->type==2){
                                    $a = Profiles::find($d->package_id);
                                    if($a){
                                        $arr = explode(",",$a->no_of_parameter);
                                        foreach($arr as $l){
                                            $b[] = Parameter::find($l)?Parameter::find($l)->name:'';
                                        }

                                        $parameter = $parameter+count($arr);
                                    }
                                }
                        }
                        $ls->parameter = $parameter;
                         $ls->paramater_data = implode("#",array_slice($b, 0, 4));
                         $list_related[] = $ls;
                        }
                        
                        
                 }
                 $data->realted_package = $list_related;
                $category = Category::where('is_deleted','0')->get();
                $popular_package = Popular_package::whereNull('deleted_at')->get();
                $setting = Setting::find(1);
                $package_list = Package::where("category_id",$id)->whereNull('deleted_at')->get();
                $reviewlist = Review::with('userdata')->where("type",'1')->where("type_id",$id)->get();
                $data->total_review = count(Review::where("type",'1')->where("type_id",$id)->get());
                $data->avg_review = Review::where("type",'1')->where("type_id",$id)->avg('ratting');

                $member_list = FamilyMember::where("user_id",Auth::id())->whereNull("deleted_at")->get();
                return view("front.package_detail")->with("category",$category)->with("data",$data)->with("package_list",$package_list)->with("popular_package",$popular_package)->with("profiles_list",$profiles_list)->with("parameter_list",$parameter_list)->with("setting",$setting)->with("reviewlist",$reviewlist)->with("member_list",$member_list)->with("totalcartmember",$this->gettotalcartmember());

        }else{
            return redirect()->back();
        }
    }

    public function show_parameter_detail(Request $request){
        $id = $request->get("id");
        Session::put("active_menu","");
        $data = Parameter::find($id);
        if($data){
                $data->package_frq = Package_FRQ::where("package_id",$id)->where("type",'2')->get();
                $category = Category::where('is_deleted','0')->get();
                $popular_package = Popular_package::whereNull('deleted_at')->get();
                $setting = Setting::find(1);
                $package_list = Package::where("category_id",$id)->whereNull('deleted_at')->get();
                $reviewlist = Review::with('userdata')->where("type",'2')->where("type_id",$id)->get();
                $data->total_review = count(Review::where("type",'2')->where("type_id",$id)->get());
                $data->avg_review = Review::where("type",'2')->where("type_id",$id)->avg('ratting');
                 $member_list = FamilyMember::where("user_id",Auth::id())->whereNull("deleted_at")->get();
                return view("front.parameter_detail")->with("category",$category)->with("data",$data)->with("package_list",$package_list)->with("popular_package",$popular_package)->with("setting",$setting)->with("reviewlist",$reviewlist)->with("totalcartmember",$this->gettotalcartmember())->with("member_list",$member_list);

        }else{
            return redirect()->back();
        }
    }

    public function show_profile_detail(Request $request){
        $id = $request->get("id");
        Session::put("active_menu","");
        $data = Profiles::find($id);
        if($data){
                $data->package_frq = Package_FRQ::where("package_id",$id)->where("type",'3')->get();
                $category = Category::where('is_deleted','0')->get();
                $popular_package = Popular_package::whereNull('deleted_at')->get();
                $package_list = Package::where("category_id",$id)->whereNull('deleted_at')->get();
                $profiles_list = Profiles::whereNull('deleted_at')->get();
                $setting = Setting::find(1);
                $parameter_list = Parameter::whereNull('deleted_at')->get();
                $arr = explode(",",$data->no_of_parameter); 

                $ls = array();                   
                    $i=0;
                    foreach($arr as $a){                        
                            $ls[] = Parameter::find($a)?Parameter::find($a):'';
                    }
                $data->testdetails = $ls;              
               
                $reviewlist = Review::with('userdata')->where("type",'3')->where("type_id",$id)->get();
                $data->total_review = count(Review::where("type",'3')->where("type_id",$id)->get());
                $data->avg_review = Review::where("type",'3')->where("type_id",$id)->avg('ratting');
                $member_list = FamilyMember::where("user_id",Auth::id())->whereNull("deleted_at")->get();
                return view("front.profile_detail")->with("category",$category)->with("data",$data)->with("package_list",$package_list)->with("popular_package",$popular_package)->with("setting",$setting)->with("reviewlist",$reviewlist)->with("totalcartmember",$this->gettotalcartmember())->with("member_list",$member_list);

        }else{
            return redirect()->back();
        }
    }  

    public function getaddress(Request $request){
        return json_encode(UserAddress::where("id",$request->get("id"))->where("user_id",Auth::id())->first());
    }

    public function post_Book_order(Request $request){
        // dd($request->all());
        $this->validate($request,[
        //   'sample_collection_address_id' =>'required',
          'date' => 'required',
          'time' => 'required',
          'payment_type' => 'required',
         
       ]);
        $getallkeys = PaymentGateway::all();
        $ls = array();
        foreach($getallkeys as $g){
            $ls[$g->payment_gateway_name."_".$g->key_name] = $g->meta_value;
        }
        $setting = Setting::find(1);
        if($request->get("payment_type")=="cod"){
           
                            $store = new Orders();
                            $store->user_id = Auth::id();
                            $store->sample_collection_address_id = $request->get("sample_collection_address_id");
                            $store->date = $request->get("date");
                            $store->time = $request->get("time");
                            $store->payment_method = $request->get("payment_type");
                            $store->token = '';
                            $store->subtotal = $request->get("subtotal");
                            $store->tax = $request->get("tax");
                            $store->final_total = $request->get("final_total");
                            $store->status = 1;
                            $store->orderplace_date = $this->getsitedate();
                            $store->save();
                            $store1 = CartMember::where("user_id",Auth::id())->get();
                            if(count($store1)>0){
                                 foreach($store1 as $s){
                                     
                                     
                                       if($s->type==1){
                                            $item_data = Package::find($s->type_id);
                                        }else if($s->type==2){
                                            $item_data = Parameter::find($s->type_id);
                                        }else{
                                            $item_data = Profiles::find($s->type_id);        
                                            if($item_data){
                                                $item_data->name = $item_data->profile_name;
                                            }
                                        }
                                         
                                        $data = new OrdersData();
                                        $data->order_id = $store->id;
                                        $data->member_id = $s->family_member_id;
                                        $data->item_id = $s->type_id;
                                        $data->type = $s->type;
                                        $data->item_name = isset($item_data->name)?$item_data->name:"";
                                        $data->parameter = $s->parameter;
                                        $data->mrp = isset($item_data->mrp)?$item_data->mrp:"0";
                                        $data->price = isset($item_data->price)?$item_data->price:"0";
                                        $data->save();
                                    
                                }
                                
                            }
                            CartMember::where("user_id",Auth::id())->delete(); 
                            DB::commit();
                            $user = User::find(Auth::id());
                            // echo "<pre>";
                            // print_r($user);
                            // exit();
                            $getuseraddress = UserAddress::find($store->sample_collection_address_id);
                            if($getuseraddress){
                                 $getmanager = User::where("user_type","2")->where("city",$getuseraddress->city)->get();
                                 foreach($getmanager as $gm){
                                    $gm->order_notification = $gm->order_notification+1;
                                    $gm->save();
                                    $data1 = array();
                                    $data1['email']=$gm->email;
                                    $data1['msg']= __("message.You Get New Booking For Test");
                                    $data1['order_id']=$store->id;
                                    $data1['customer_name'] = isset($user)?$user->name:'';
                                    $data1['manager_name'] = $gm->name;
                                    
                                            $result=Mail::send('email.order_status', ['user' => $data1], function($message) use ($data1){
                                                    $message->to($data1['email'],$data1['manager_name'])->subject(__('message.site_name')); 
                                            });
                                     
                                 }
                            }
                            $msg = __('message.Test Book Successfully');
                            $this->send_notification_order_android($setting->android_server_key,$store->user_id,$msg,$store->id);
                            $this->send_notification_order_android($setting->ios_server_key,$store->user_id,$msg,$store->id);
                            Session::flash('message',__('message.Test Book Successfully')); 
                            Session::flash('alert-class', 'alert-success');
                           return redirect()->route('dashboard', ['type' => 'upcoming']);
                    
        }
        if($request->get("payment_type")=="braintree"){
                $gateway = new \Braintree\Gateway([
                    'environment' => $ls['Braintree_environment'],
                    'merchantId' => $ls['Braintree_merchantId'],
                    'publicKey' => $ls['Braintree_publicKey'],
                    'privateKey' => $ls['Braintree_privateKey']
                 ]);
                $nonce = $request->get("payment_method_nonce");
                $result = $gateway->transaction()->sale(['amount' => $request->get("final_total"),'paymentMethodNonce' => $nonce,'options' => ['submitForSettlement' => true]]);
                if ($result->success) {
                    $transaction = $result->transaction;
                    DB::beginTransaction();
                    try {
                            $store = new Orders();
                            $store->user_id = Auth::id();
                            $store->sample_collection_address_id = $request->get("sample_collection_address_id");
                            $store->date = $request->get("date");
                            $store->time = $request->get("time");
                            $store->payment_method = $request->get("payment_type");
                            $store->token = $transaction->id;
                            $store->subtotal = $request->get("subtotal");
                            $store->tax = $request->get("tax");
                            $store->final_total = $request->get("final_total");
                            $store->status = 1;
                            $store->orderplace_date = $this->getsitedate();
                            $store->save();
                            $store1 = CartMember::where("user_id",Auth::id())->get();
                            if(count($store1)>0){
                                 foreach($store1 as $s){
                                       if($s->type==1){
                                            $item_data = Package::find($s->type_id);
                                        }else if($s->type==2){
                                            $item_data = Parameter::find($s->type_id);
                                        }else{
                                            $item_data = Profiles::find($s->type_id);
                                            if($item_data){
                                                $item_data->name = $item_data->profile_name;
                                            }
                                        }
                                        $data = new OrdersData();
                                        $data->order_id = $store->id;
                                        $data->member_id = $s->family_member_id;
                                        $data->item_id = $s->type_id;
                                        $data->type = $s->type;
                                        $data->item_name = $item_data->name;
                                        $data->parameter = $s->parameter;
                                        $data->mrp = $item_data->mrp;
                                        $data->price = $item_data->price;
                                        $data->save();
                                    
                                }
                            }
                            CartMember::where("user_id",Auth::id())->delete(); 
                            DB::commit();
                           
                            $getuseraddress = UserAddress::find($store->sample_collection_address_id);
                            if($getuseraddress){
                                 $getmanager = User::where("user_type","2")->where("city",$getuseraddress->city)->get();
                                 foreach($getmanager as $gm){
                                    $gm->order_notification = $gm->order_notification+1;
                                    $gm->save();
                                    $data1 = array();
                                    $data1['email']=$gm->email;
                                    $data1['msg']= __("message.You Get New Booking For Test");
                                    $data1['order_id']=$store->id;
                                    $data1['customer_name'] = User::find($data->user_id)?User::find($data->user_id)->name:'';
                                    $data1['manager_name'] = $gm->name;
                                    try {
                                            $result=Mail::send('email.order_status', ['user' => $data1], function($message) use ($data1){
                                                    $message->to($data1['email'],$data1['manager_name'])->subject(__('message.site_name')); 
                                            });
                                    } catch (\Exception $e) {
                                    } 
                                 }
                            }
                            $msg = __('message.Test Book Successfully');
                            $this->send_notification_order_android($setting->android_server_key,$store->user_id,$msg,$store->id);
                            $this->send_notification_order_android($setting->ios_server_key,$store->user_id,$msg,$store->id);
                            Session::flash('message',__('message.Test Book Successfully')); 
                            Session::flash('alert-class', 'alert-success');
                           return redirect()->route('dashboard', ['type' => 'upcoming']);
                    }catch (\Exception $e) {
                            DB::rollback();
                            Session::flash('message1',$e); 
                            Session::flash('alert-class', 'alert-danger');
                            return redirect()->back();
                    }
                }else{
                        $errorString = "";
                        foreach($result->errors->deepAll() as $error) {
                            $errorString .= 'Error: ' . $error->code . ": " . $error->message . "\n";
                        }
                        Session::flash('message1',$errorString); 
                        Session::flash('alert-class', 'alert-danger');
                        return redirect()->back();
                }
        }
        if($request->get("payment_type")=="stripe"){
            DB::beginTransaction();      
            try {
                    try{
                            \Stripe\Stripe::setApiKey($ls['Stripe_secert_key']);
                            $unique_id = uniqid(); 
                            $charge = \Stripe\Charge::create(array(
                                'description' => "Amount: ".$request->get("final_total").' - '. $unique_id,
                                'source' => $request->get('stripeToken'),                    
                                'amount' => (int)($request->get("final_total") * 100), 
                                'currency' => $ls['Stripe_currency']
                            ));
                              $store = new Orders();
                            $store->user_id = Auth::id();
                            $store->sample_collection_address_id = $request->get("sample_collection_address_id");
                            $store->date = $request->get("date");
                            $store->time = $request->get("time");
                            $store->payment_method = $request->get("payment_type");
                            $store->token = $charge->id;
                            $store->subtotal = $request->get("subtotal");
                            $store->tax = $request->get("tax");
                            $store->final_total = $request->get("final_total");
                            $store->orderplace_date = $this->getsitedate();
                            $store->status = 1;
                            $store->save();
                            $store1 = CartMember::where("user_id",Auth::id())->get();
                            if(count($store1)>0){
                                 foreach($store1 as $s){
                                       if($s->type==1){
                                            $item_data = Package::find($s->type_id);
                                        }else if($s->type==2){
                                            $item_data = Parameter::find($s->type_id);
                                        }else{
                                            $item_data = Profiles::find($s->type_id);
                                            if($item_data){
                                                $item_data->name = $item_data->profile_name;
                                            }
                                        }
                                        $data = new OrdersData();
                                        $data->order_id = $store->id;
                                        $data->member_id = $s->family_member_id;
                                        $data->item_id = $s->type_id;
                                        $data->type = $s->type;
                                        $data->item_name = $item_data->name;
                                        $data->parameter = $s->parameter;
                                        $data->mrp = $item_data->mrp;
                                        $data->price = $item_data->price;
                                        $data->save();
                                    
                                }
                            }
                            CartMember::where("user_id",Auth::id())->delete(); 
                            DB::commit();
                            
                            $getuseraddress = UserAddress::find($store->sample_collection_address_id);
                            if($getuseraddress){
                                 $getmanager = User::where("user_type","2")->where("city",$getuseraddress->city)->get();
                                 foreach($getmanager as $gm){
                                    $gm->order_notification = $gm->order_notification+1;
                                    $gm->save();
                                    $data1 = array();
                                    $data1['email']=$gm->email;
                                    $data1['msg']= __("message.You Get New Booking For Test");
                                    $data1['order_id']=$store->id;
                                    $data1['customer_name'] = User::find($data->user_id)?User::find($data->user_id)->name:'';
                                    $data1['manager_name'] = $gm->name;
                                    try {
                                            $result=Mail::send('email.order_status', ['user' => $data1], function($message) use ($data1){
                                                    $message->to($data1['email'],$data1['manager_name'])->subject(__('message.site_name')); 
                                            });
                                    } catch (\Exception $e) {
                                    } 
                                 }
                            }
                            $msg = __('message.Test Book Successfully');
                            $this->send_notification_order_android($setting->android_server_key,$store->user_id,$msg,$store->id);
                            $this->send_notification_order_android($setting->ios_server_key,$store->user_id,$msg,$store->id);
                           
                    } catch (\Stripe\Exception\RateLimitException $e) {
                          Session::flash('message', $e->getMessage()); 
                          Session::flash('alert-class', 'alert-danger');
                          return redirect()->back();
                    } catch (\Stripe\Exception\InvalidRequestException $e) {
                          Session::flash('message', $e->getMessage()); 
                          Session::flash('alert-class', 'alert-danger');
                          return redirect()->back();
                    } catch (\Stripe\Exception\AuthenticationException $e) {
                          Session::flash('message', $e->getMessage()); 
                          Session::flash('alert-class', 'alert-danger');
                          return redirect()->back();
                    } catch (\Stripe\Exception\ApiConnectionException $e) {
                          Session::flash('message', $e->getMessage()); 
                          Session::flash('alert-class', 'alert-danger');
                          return redirect()->back();
                    } catch (\Stripe\Exception\ApiErrorException $e) {
                          Session::flash('message', $e->getMessage()); 
                          Session::flash('alert-class', 'alert-danger');
                          return redirect()->back();
                    } catch (Exception $e) {
                          Session::flash('message', $e->getMessage()); 
                          Session::flash('alert-class', 'alert-danger');
                          return redirect()->back();
                   }
                    DB::commit();
                    Session::flash('message',__('message.Test Book Successfully')); 
                    Session::flash('alert-class', 'alert-success');
                    return redirect()->route('dashboard', ['type' => 'upcoming']);
            } catch (\Exception $e) {
                      DB::rollback();
                      // Session::flash('message1', "Something Getting Worng");
                      Session::flash('message1',__('message.Something Getting Worng')); 
                      Session::flash('alert-class', 'alert-danger');
                      return redirect()->back();
            }
        }
    }
    
    public function privacy_front_app(){
        $data=About::find(1);
        $setting=Setting::find(1);
        return view('front.privacy_policy',compact('data','setting'));
    }
    
    public function accountdeletion(){
        $data=About::find(1);
        $setting=Setting::find(1);
        return view('front.accountdeletion',compact('data','setting'));
    }

    public function about(){
      $data=About::find(1);
      $setting=Setting::find(1);
      return view('admin.about',compact('data','setting'));
    }
    
    public function admin_privacy(){
      $data=About::find(1);
      $setting=Setting::find(1);
      return view('admin.terms',compact('data','setting'));
    }
    
    public function terms_user(){
      $data=About::find(1);
      $setting=Setting::find(1);
      $popular_package = Popular_package::whereNull('deleted_at')->get();
        $category = Category::where('is_deleted','0')->get();
       
        Session::put("active_menu","2");
      return view('front.terms',compact('data','setting','popular_package','category'));
    }
    
    public function app_privacy(){
      $data=About::find(1);
      $setting=Setting::find(1);
      return view('admin.privecy-app',compact('data','setting'));
    }
    
    public function data_deletion(){
      $data=About::find(1);
      $setting=Setting::find(1);
      return view('admin.data-deletion',compact('data','setting'));
    }
    
   public function edit_about(Request $request){
      $data=About::find(1);
       $setting=Setting::find(1);
       $data->about = $request->get('about');
       $data->save();
      return redirect('about');
    }
    
    public function edit_terms(Request $request){
      $data=About::find(1);
      $setting=Setting::find(1);
      $data->trems = $request->get('trems');
       $data->save();
      return redirect('Terms_condition');
    }
    
    public function edit_app_privacy(Request $request){
      $data=About::find(1);
      $setting=Setting::find(1);
      $data->privacy = $request->get('privacy');
       $data->save();
      return redirect('app_privacy');
    }
    
    public function edit_data_deletion(Request $request){
      $data=About::find(1);
      $setting=Setting::find(1);
      $data->data_deletion = $request->get('data_deletion');
       $data->save();
      return redirect('data_deletion');
    }
}
